/*
 * Decompiled with CFR 0.152.
 */
package com.trackingpremium.report.service;

import com.trackingpremium.report.dto.CompanyRequest;
import com.trackingpremium.report.dto.ReportDetail;
import com.trackingpremium.report.dto.ReportResponse;
import com.trackingpremium.report.model.DatabaseConnection;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.yaml.snakeyaml.Yaml;

@Service
public class ReportService {
    private final DatabaseConnection databaseConnection;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private static final String TEMP_DIR = System.getProperty("java.io.tmpdir") + "/tp_reports";
    private static final long CLEANUP_INTERVAL = 15L;
    private static final long FILE_MAX_AGE = 60L;
    private static final Logger logger = LoggerFactory.getLogger(ReportService.class);
    private Path rootPath;
    @Value(value="${jasper.reports.path}")
    private String jasperReportsPath;
    @Value(value="${servicio.base-de-datos}")
    private String nombreBaseDeDatos;

    @Autowired
    public ReportService(DatabaseConnection databaseConnection) {
        this.databaseConnection = databaseConnection;
    }

    @PostConstruct
    public void init() {
        new File(TEMP_DIR).mkdirs();
        this.scheduler.scheduleAtFixedRate(this::cleanupOldFiles, 15L, 15L, TimeUnit.MINUTES);
        this.rootPath = Paths.get(this.jasperReportsPath, new String[0]).normalize();
        if (!Files.exists(this.rootPath, new LinkOption[0])) {
            logger.warn("\u26a0\ufe0f La ruta de reportes no existe en el arranque: {}", (Object)this.jasperReportsPath);
        }
    }

    public List<ReportResponse> obtenerReportesPersonalizadosPorTipo(CompanyRequest request) {
        Path carpetaEmpresa = this.rootPath.resolve(request.getReportType()).resolve(request.getCompanyName());
        if (Files.exists(carpetaEmpresa, new LinkOption[0]) && Files.isDirectory(carpetaEmpresa, new LinkOption[0])) {
            List<ReportResponse> list;
            block9: {
                Stream<Path> archivos = Files.list(carpetaEmpresa);
                try {
                    list = archivos.filter(f -> f.toString().endsWith(".jasper")).filter(f -> !f.getFileName().toString().toLowerCase().contains("encabezado")).filter(f -> !f.getFileName().toString().toLowerCase().contains("termcond")).map(f -> {
                        String archivo = f.getFileName().toString();
                        String etiqueta = archivo.replace(".jasper", "");
                        return new ReportResponse(etiqueta, archivo, request.getReportType());
                    }).collect(Collectors.toList());
                    if (archivos == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (archivos != null) {
                            try {
                                archivos.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        logger.error("Error al leer archivos en {}", (Object)carpetaEmpresa, (Object)e);
                    }
                }
                archivos.close();
            }
            return list;
        }
        return List.of();
    }

    public Map<String, List<ReportDetail>> obtenerReportesAgrupados(CompanyRequest request) {
        HashMap<String, List<ReportDetail>> mapaFinal = new HashMap<String, List<ReportDetail>>();
        try (Stream<Path> carpetasTipos = Files.list(this.rootPath);){
            carpetasTipos.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(tipoFolder -> {
                String nombreTipo = tipoFolder.getFileName().toString();
                Path rutaEmpresa = tipoFolder.resolve(request.getCompanyName());
                if (Files.exists(rutaEmpresa, new LinkOption[0]) && Files.isDirectory(rutaEmpresa, new LinkOption[0])) {
                    try (Stream<Path> archivos = Files.list(rutaEmpresa);){
                        List reportes = archivos.filter(f -> f.toString().endsWith(".jasper")).filter(f -> !f.getFileName().toString().toLowerCase().contains("encabezado")).filter(f -> !f.getFileName().toString().toLowerCase().contains("termcond")).map(f -> new ReportDetail(f.getFileName().toString().replace(".jasper", ""), f.getFileName().toString())).collect(Collectors.toList());
                        if (!reportes.isEmpty()) {
                            mapaFinal.put(nombreTipo, reportes);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (IOException e) {
            logger.error("Error leyendo rootPath", (Throwable)e);
        }
        return mapaFinal;
    }

    @PreDestroy
    public void cleanup() {
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
        }
    }

    private void cleanupOldFiles() {
        try {
            File tempDir = new File(TEMP_DIR);
            if (!tempDir.exists()) {
                return;
            }
            File[] files = tempDir.listFiles();
            if (files == null) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            for (File file : files) {
                long fileAge = currentTime - file.lastModified();
                if (fileAge <= TimeUnit.MINUTES.toMillis(60L)) continue;
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String generateFileName(String name, String format) {
        StringBuilder fileName = new StringBuilder();
        fileName.append(name);
        fileName.append("_").append(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss")));
        fileName.append(".").append(format.toLowerCase());
        return fileName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JasperPrint generateJasperPrint(String company, String type, String name, Map<String, Object> params) throws Exception {
        String jasperFileName = name.trim() + ".jasper";
        String rootFolder = this.jasperReportsPath + type + "/";
        String subRootFolder = rootFolder + company + "/";
        File subDirFile = new File(subRootFolder + jasperFileName);
        if (subDirFile.exists() && subDirFile.canRead()) {
            rootFolder = subRootFolder;
        }
        String jrxmlPath = rootFolder + jasperFileName;
        Connection conn = null;
        try {
            HashMap parameters;
            conn = this.databaseConnection.getConnection();
            JasperReport jasperReport = null;
            FileInputStream jasperStream = null;
            try {
                jasperStream = new FileInputStream(new File(jrxmlPath));
                jasperReport = (JasperReport)JRLoader.loadObject((InputStream)jasperStream);
                ((InputStream)jasperStream).close();
            }
            catch (FileNotFoundException e) {
                throw new Exception("Could not find Jasper file: " + jrxmlPath, e);
            }
            HashMap hashMap = parameters = params != null ? params : new HashMap();
            if (params != null && params.containsKey("companyId")) {
                parameters.put("companyId", params.get("companyId"));
            }
            if (params != null && params.containsKey("start_date")) {
                parameters.put("start_date", params.get("start_date"));
            }
            if (params != null && params.containsKey("end_date")) {
                parameters.put("end_date", params.get("end_date"));
            }
            if (params != null && params.containsKey("documentId")) {
                parameters.put("documentId", params.get("documentId"));
            }
            if (params != null && params.containsKey("language")) {
                parameters.put("language", params.get("language"));
                Object languageObj = params.get("language");
                if (languageObj != null && languageObj instanceof String) {
                    String languageCode = (String)languageObj;
                    if ("en".equals(languageCode)) {
                        locale = new Locale("en", "US");
                        parameters.put("REPORT_LOCALE", locale);
                    } else {
                        locale = new Locale("es", "VE");
                        parameters.put("REPORT_LOCALE", locale);
                    }
                } else {
                    Locale defaultLocale = new Locale("es", "VE");
                    parameters.put("REPORT_LOCALE", defaultLocale);
                }
            } else {
                Locale defaultLocale = new Locale("es", "VE");
                parameters.put("REPORT_LOCALE", defaultLocale);
            }
            ClassPathResource resourcey = new ClassPathResource("reports/config/reports-config.yaml");
            InputStream inputStream = resourcey.getInputStream();
            Yaml yaml = new Yaml();
            Map config = (Map)yaml.load(inputStream);
            Map reportConfig = (Map)config.get(type.trim());
            if (reportConfig == null) {
                throw new Exception("Could not find report config for type: " + type);
            }
            System.out.println("Keys in reportConfig: " + String.valueOf(reportConfig.keySet()));
            Map report = (Map)reportConfig.get(name.trim());
            if (report == null) {
                throw new Exception("ERROR: The report configuration name '" + name.trim() + "' was not found under type '" + type + "'. Check for case sensitivity or invisible characters in the YAML/request.");
            }
            List subreports = (List)report.get("subreports");
            for (Map subreport : subreports) {
                FileInputStream subreportStream;
                String subreportName = (String)subreport.get("name");
                String subreportJrxmlPath = null;
                subreportJrxmlPath = subDirFile.exists() && subDirFile.canRead() ? type + "/" + company + "/" + subreportName + ".jasper" : type + "/" + subreportName + ".jasper";
                String fullSubreportPath = this.jasperReportsPath + subreportJrxmlPath;
                try {
                    subreportStream = new FileInputStream(new File(fullSubreportPath));
                }
                catch (FileNotFoundException e) {
                    throw new Exception("Could not find subreport file: " + fullSubreportPath, e);
                }
                JasperReport compiledSubreport = (JasperReport)JRLoader.loadObject((InputStream)subreportStream);
                ((InputStream)subreportStream).close();
                JRSaver.saveObject((Object)compiledSubreport, (String)(subreportName + ".jasper"));
                parameters.put("SUBREPORT_DIR_" + subreportName, subreportName + ".jasper");
            }
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (Connection)conn);
            return jasperPrint;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String generateReport(String company, String type, String name, Map<String, Object> params, String format) throws Exception {
        try {
            JasperPrint jasperPrint = this.generateJasperPrint(company, type, name, params);
            String fileName = this.generateFileName(name, format);
            if (format.equalsIgnoreCase("html")) {
                File tempDir = new File(TEMP_DIR);
                if (!tempDir.exists()) {
                    tempDir.mkdirs();
                }
                String htmlFilePath = tempDir.getAbsolutePath() + File.separator + fileName;
                JasperExportManager.exportReportToHtmlFile((JasperPrint)jasperPrint, (String)htmlFilePath);
                return "/reports/html/" + fileName;
            }
            throw new Exception("Unsupported format: " + format);
        }
        catch (JRException e) {
            throw new Exception("Error generating report: " + e.getMessage(), e);
        }
    }

    public void generateReport(HttpServletResponse response, String company, String type, String name, Map<String, Object> params, String format) throws Exception {
        try {
            JasperPrint jasperPrint = this.generateJasperPrint(company, type, name, params);
            ServletOutputStream out = response.getOutputStream();
            String fileName = this.generateFileName(name, format);
            switch (format.toLowerCase()) {
                case "pdf": {
                    response.setContentType("application/pdf");
                    response.setHeader("Content-Disposition", "inline; filename=" + fileName);
                    JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)out);
                    break;
                }
                case "xlsx": {
                    response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                    response.setHeader("Content-Disposition", "inline; filename=" + fileName);
                    JRXlsxExporter exporter = new JRXlsxExporter();
                    exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
                    exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((OutputStream)out));
                    exporter.exportReport();
                    break;
                }
                case "csv": {
                    response.setContentType("text/csv");
                    response.setHeader("Content-Disposition", "inline; filename=" + fileName);
                    JRCsvExporter csvExporter = new JRCsvExporter();
                    csvExporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
                    csvExporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput((OutputStream)out));
                    csvExporter.exportReport();
                    break;
                }
                default: {
                    throw new Exception("Unsupported format: " + format);
                }
            }
            out.close();
        }
        catch (JRException e) {
            throw new Exception("Error generating report: " + e.getMessage(), e);
        }
    }
}

